#!/usr/bin/env python
# -*- coding: utf-8; test-case-name: compass.test.agentclient.test_service -*-
# report bug to: riverfor@sina.com.cn
"""
This module includes the common functions that the service operation will call
"""
from compass.common.framework import DataPacked

### the part of request about service
class ServiceRequest(DataPacked):
    def add_service(self, service_data):
        """
	Add a service(request by admin client)

	service_data: (service_id, desc, password,\
	    host, port, domain, tacitics, status)
	"""
	self.cmd_callback(self.disconnect, ())
	return self.common_out('add_service', \
	    {'service_id': service_data['service_id'], \
	     'desc': service_data['desc'], \
	     'password': service_data['password'], \
	     'host': service_data['host'], \
	     'port': service_data['port'], \
	     'domain': service_data['domain'], \
	     'tactics': service_data['tactics'], \
	     'status': service_data['status']})

    def on_gnsp_add_service_resp(self, packet):
        """call disconnect
	"""
	bag = packet.body.fields
	return self.cmd_out(bag['status'])

    def service_login(self, service_id, listen_host, listen_port, status):
	"""
	login a service

	params:
	service_id, listen_host, listen_port, status
	"""
	return self.common_out('service_login', \
	    {'service_id':  service_id, \
	     'listen_host': listen_host, \
	     'listen_port': listen_port, \
	     'status': status})

    def on_gnsp_service_login_resp(self, packet):
	"""undocumented
	"""
	bag = packet.body.fields
	return self.cmd_out(bag['status'])

    def service_logout(self, service_id):
	"""undocumented
	"""
	self.cmd_callback(self.disconnect, ())
        return self.common_out('service_logout', {'service_id': service_id})

    def on_gnsp_service_logout_resp(self, message):
        pass

    def service_warning(self, service_id, warning_id, level):
	"""undocumented
	"""
        return self.common_out('service_warning', \
	                       {'service_id': service_id,
				'warning_id': warning_id,
				'level': level})

    def on_gnsp_service_warning_resp(self, message):
        pass

    def get_service(self, service_id):
        return self.sendData(self.data_packed('get_service', ('service_id', service_id)))
	
    def on_gnsp_get_service_resp(self, message):
        pass
	
    def del_service(self, service_id):
        return self.sendData(self.data_packed('del_service', ('service_id', service_id)))
	
    def on_gnsp_del_service_resp(self, messages):
        pass

    def modify_service(self, mask, service_data):
	"""undocumented
	"""
        return self.common_out('modify_service', \
	                       {'service_id': service_data['service_id'], \
				'mask': mask, \
				'desc': service_data['desc'], \
				'password': service_data['password'], \
				'host': service_data['host'], \
				'port': service_data['port'], \
				'domain': service_data['domain'], \
				'tactics': service_data['tactics'], \
				'status': service_data['status']})

    def on_gnsp_modify_service_resp(self, message):
        pass

    def service_notify(self, service_id, level, weight, status):
        packet = self.data_packed('service_notify',
	                          ('service_id', service_id),
				  ('level', level),
				  ('weight', weight),
				  ('status', status)
				 )
	return self.sendData(packet)			 

    def on_gnsp_service_notify_resp(self, message):
        pass
