# -*- coding: utf-8 -*-
#
#
# $Id: gnsp.py,v 1.4 2004/11/15 07:00:13 xyb Exp $

"""Open Global Name Service Protocol

Stability: None

@author: U{HD<mailto:hdcola@gmail.com>}

@see: Open Global Name Service Protocol规范
"""

from compass.uss.protocols import byteprotocol
from compass.uss.message import gnspmsg

class GNSProtocol(byteprotocol.ByteMessageProtocol):
    """缺省GNS协议实现"""
    def MessageReceived(self,packet):
        """接收到一条消息，对该消息进行处理"""
        message = gnspmsg.GNSPMessage()
        message.loadMessage(packet)
        self.MessageProcess(message)

    def MessageProcess(self, message):
        """调用指定的方法来处理收到的消息"""
        method = getattr(self , "on_gnsp_%s" % message.msgname, None)
        return method(message)
