# -*- coding: utf-8; test-case-name: compass.test.test_usspmsg -*-
#
#
# $Id: usspmsg.py,v 1.5 2004/11/15 07:03:09 xyb Exp $

"""Open Unified Storage System Protocol

Stability: None

@author: U{HD<mailto:hdcola@gmail.com>}

@see: Open Unified Storage System Protocol规范
"""
from compass.uss.message import bytemsg
import struct

class USSPMessage(bytemsg.ByteMessage):
    """USSP 消息基类"""
    def __init__(self):
        # 消息头
        self.head = bytemsg.ByteMessageHead(self)
        # 消息体
        self.body = bytemsg.ByteMessageBody(self)
        # 消息工具
        self.msgutilcls = USSPMessageUtil
        # 协议名称
        self.protocolname = 'ussp'
        # 当前的消息名称
        self.msgname = ''

    def pack_ussp_connect(self, fields):
        """connect报文打包"""
        return struct.pack('6s16sI8s',
                fields['system_id'],
                fields['auth_source'],
                fields['version'],
                fields['time_stamp']
                )

    def unpack_ussp_connect(self, packet):
        """connect报文解包"""
        self.body.fields['system_id'], \
            self.body.fields['auth_source'], \
            self.body.fields['version'], \
            self.body.fields['time_stamp'] = \
            struct.unpack('6s16sI8s',packet)

    def pack_ussp_connect_resp(self, fields):
        """connect_resp报文打包"""
        return struct.pack('II',
                fields['status'],
                fields['version']
                )

    def unpack_ussp_connect_resp(self, packet):
        """connect_resp报文解包"""
        self.body.fields['status'], \
            self.body.fields['version'] = \
            struct.unpack('II',packet)

    def pack_ussp_mail_counter(self, fields):
        """mail_counter报文打包"""
        return struct.pack('16s', fields['uid'])

    def unpack_ussp_mail_counter(self, packet):
        """mail_counter报文解包"""
        (self.body.fields['uid'],) = struct.unpack('16s',packet)

    def pack_ussp_mail_counter_resp(self, fields):
        """mail_counter_resp报文打包"""
        return struct.pack('16sI',
                fields['uid'],
                fields['number']
                )

    def unpack_ussp_mail_counter_resp(self, packet):
        """mail_counter_resp报文解包"""
        self.body.fields['uid'], \
            self.body.fields['number'] = \
            struct.unpack('16sI', packet)

    def pack_ussp_terminate(self, fields):
        """terminate报文体为空"""
        return None

    def unpack_ussp_terminate(self, packet):
        """terminate报文体为空"""
        pass

    def pack_ussp_terminate_resp(self, fields):
        """terminate_resp报文体为空"""
        return None

    def unpack_ussp_terminate_resp(self, packet):
        """terminate_resp报文体为空"""
        pass

class USSPMessageUtil(bytemsg.ByteMessageUtil):
    """USSP消息处理工具类"""
    def __init__(self):
        pass

# USSP Message定义
USSPMessageUtil.commandinfo = {
    0x00000000L : 'generic_noop',        # 什么都不做的报文
    0xff000000L : 'generic_noop_resp',   # 什么都不做的报文回复
    0x00000001L : 'connect',             # 连接请求报文
    0xff000001L : 'connect_resp',        # 连接请求报文回复
    0x00000002L : 'terminate',           # 断开连接请求报文
    0xff000002L : 'terminate_resp',      # 断开连接请求报文回复
    0x00000005L : 'mail_counter',        # 邮件统计报文
    0xff000005L : 'mail_counter_resp'    # 邮件统计报文回复
    }

# 通过名称查出消息ID的结构定义
USSPMessageUtil.nametoid = {}
for k in USSPMessageUtil.commandinfo.keys():
    USSPMessageUtil.nametoid[USSPMessageUtil.commandinfo[k]] = k
