#!/usr/bin/env python
# -*- coding: utf-8; test-case-name: compass.test.test_gns -*-
#
# $Id: gnsd.py,v 1.5 2004/11/15 07:03:09 xyb Exp $
"""实现了Global Name Service的Daemon程序
"""

from compass.uss.message import gnspmsg
from compass.uss.protocols import gnsp
from twisted.internet import reactor, protocol
from time import clock

class GNSServerProtocol(gnsp.GNSProtocol):
    """建立一个USS服务器的协议处理"""
    def connectionMade(self):
        """建立连接了，先什么都不做"""
        pass

    def on_gnsp_connect(self, message):
        """处理客户机connect报文"""
        smessage = gnspmsg.GNSPMessage()
        smessage.setMsgName('connect_resp')
        smessage.body.setField('status',1)
        smessage.body.setField('version',1)
        self.sendData(smessage.packed())

    def on_gnsp_mail_counter(self, message):
        """处理客户机发来的mail_counter报文"""
        smessage = gnspmsg.GNSPMessage()
        smessage.setMsgName('mail_counter_resp')
        smessage.body.setField('uid',message.body.fields['uid'])
        smessage.body.setField('number',2028)
        self.sendData(smessage.packed())

    def on_gnsp_terminate(self, message):
        """处理客户机terminate报文"""
        smessage = gnspmsg.GNSPMessage()
        smessage.setMsgName('terminate_resp')
        self.sendData(smessage.packed())

class GNSServerFactory(protocol.ServerFactory):
    """GNS服务器工厂"""
    protocol = GNSServerProtocol

def main():
    f = GNSServerFactory()
    reactor.listenTCP(7890, f)
    reactor.run()

if __name__ == "__main__":
    main()
