#!/usr/bin/env python
# -*- coding: utf-8 -*-

from twisted.trial import unittest
from framework import run
from compass.uss.message import usspmsg

class USSPMessageConnectTest(unittest.TestCase):
    msgname = 'connect'
    items = (('system_id', 'sys001'),
            ('auth_source', 'xyb4567890123456'),
            ('version', 0x0100),
            ('time_stamp', '20041109'),
            )
    packet = '\x00\x00\x000\x00\x00\x00\x01\x00\x00\x00\x00sys001xyb4567890123456\x00\x00\x00\x01\x00\x0020041109'

    def testMessage(self):
        # test package a message
        m = usspmsg.USSPMessage()
        m.setMsgName(self.msgname)
        self.assertEqual(m.msgname, self.msgname)
        for f,v in self.items:
            m.body.setField(f, v)
        for f,v in self.items:
            self.assertEqual(m.body.fields[f], v)
        self.assertEqual(m.packed(), self.packet)

        # test unpack
        n = usspmsg.USSPMessage()
        n.loadMessage(self.packet)
        self.assertEqual(n.head.length, len(self.packet))
        self.assertEqual(n.packed(), self.packet)

class USSPMessageConnectRespTest(USSPMessageConnectTest):
    msgname = 'connect_resp'
    items = (('status', 0x1234),
            ('version', 0xcdef),
            )
    packet = '\x00\x00\x00\x14\xff\x00\x00\x01\x00\x00\x00\x004\x12\x00\x00\xef\xcd\x00\x00'

class USSPMessageGenericNoopTest(USSPMessageConnectTest):
    msgname = 'generic_noop'
    items = (
            )
    packet = '\x00\x00\x00\x0c\x00\x00\x00\x00\x00\x00\x00\x00'

class USSPMessageGenericNoopRespTest(USSPMessageConnectTest):
    msgname = 'generic_noop_resp'
    items = (
            )
    packet = '\x00\x00\x00\x0c\xff\x00\x00\x00\x00\x00\x00\x00'

class USSPMessageTerminateTest(USSPMessageConnectTest):
    msgname = 'terminate'
    items = (
            )
    packet = '\x00\x00\x00\x0c\x00\x00\x00\x02\x00\x00\x00\x00'

class USSPMessageTerminateRespTest(USSPMessageConnectTest):
    msgname = 'terminate_resp'
    items = (
            )
    packet = '\x00\x00\x00\x0c\xff\x00\x00\x02\x00\x00\x00\x00'

class USSPMessageMailCounterTest(USSPMessageConnectTest):
    msgname = 'mail_counter'
    items = (
            ('uid', '1234567890123456'),
            )
    packet = '\x00\x00\x00\x1c\x00\x00\x00\x05\x00\x00\x00\x001234567890123456'

class USSPMessageMailCounterRespTest(USSPMessageConnectTest):
    msgname = 'mail_counter_resp'
    items = (
            ('uid', '1234567890123456'),
            ('number', 0xcdef),
            )
    packet = '\x00\x00\x00 \xff\x00\x00\x05\x00\x00\x00\x001234567890123456\xef\xcd\x00\x00'

if '__main__' == __name__:
    run()
