#!/usr/bin/env python
# -*- coding: utf-8 -*-

from framework import run
from twisted.trial import unittest
from compass.uss.message import gnspmsg

class messageTest(unittest.TestCase):
    def setUp(self):
        pass

    def tearDown(self):
        pass

    def testConnectMessage(self):
        msgname = 'connect'
        items = (('system_id', 'sys001'),\
                ('auth_source', 'xyb4567890123456'),\
                ('version', 0x0100),\
                ('time_stamp', '20041109'),\
                )
        binmsg = '\x00\x00\x00,\x00\x00\x00\x01sys001xyb4567890123456\x00\x00\x00\x01\x00\x0020041109'

        # test package a message
        m = gnspmsg.GNSPMessage()
        m.setMsgName(msgname)
        self.assertEqual(m.msgname, msgname)
        for f,v in items:
            m.body.setField(f, v)
        for f,v in items:
            self.assertEqual(m.body.fields[f], v)
        self.assertEqual(m.packed(), binmsg)
        del m

        # test unpack
        n = gnspmsg.GNSPMessage()
        self.assertNotEqual(n.head.length, 44)
        n.loadMessage(binmsg)
        self.assertEqual(n.head.length, 44)
        self.assertEqual(n.packed(), binmsg)

    def testConnectRespMessage(self):
        msgname = 'connect_resp'
        items = (('status', 0xfedc),\
                ('version', 0x0001),\
                )
        binmsg = '\x00\x00\x00\x10\xff\x00\x00\x01\xdc\xfe\x00\x00\x01\x00\x00\x00'

        m = gnspmsg.GNSPMessage()
        m.setMsgName(msgname)
        self.assertEqual(m.msgname, msgname)
        for f,v in items:
            m.body.setField(f, v)
        for f,v in items:
            self.assertEqual(m.body.fields[f], v)
        self.assertEqual(m.packed(), binmsg)

    def testTerminate(self):
        m = gnspmsg.GNSPMessage()
        m.setMsgName('terminate')
        self.assertEqual(m.head.length, 8)
        self.assertEqual(m.packed(), '\x00\x00\x00\x08\x00\x00\x00\x02')

    def testGenericNoop(self):
        m = gnspmsg.GNSPMessage()
        m.setMsgName('generic_noop')
        self.assertEqual(m.head.length, 8)
        self.assertEqual(m.packed(), '\x00\x00\x00\x08\x00\x00\x00\x00')

if '__main__' == __name__:
    run()
