#-------------------------------------------------
#The file is for the Calc24P as top10 list.
#It is written by Chao Xiong, July, 2006
#The version is 1.05
#-------------------------------------------------



"""The module is designed for realizing the TOP10 list.
It generates and updates a data file to save the top 10
grades.
The GUI is also built here.
The class name TopList is defined.
"""


import pygame
import sys, os
import time
from pygame.locals import *
from textimage import *
from keyInput import KeyInput
##from savefile import Savefile

if not pygame.font: print 'Warning, font is invalid...'
if not pygame.mixer: print 'Warning mixer is invalid...'

class TopList:
    """The main class in this module is for the operation of
    the top list. It will modify the save data files, and display
    that with GUI."""
    def __init__(self, width = 640, height = 480):
        """Initializing the class and pygame."""
        pygame.init()
        """Set the window size."""
        self.width = width
        self.height = height
        """Create the screen"""
        pygame.display.set_caption('24 Points Calculation')
        self.screen = pygame.display.set_mode((self.width, self.height))
        """Create RGB mode"""
        self.RGB = [self.R, self.G, self.B] = [0, 0, 0]
        self.key = KeyInput()
        """Create the background"""
        

        try:
            self.background, self.backrect = load_image('toplist.jpg')
            self.screen.blit(self.background, self.backrect)
        except:
            self.background = pygame.Surface(self.screen.get_size())
            self.background = self.background.convert()
            self.background.fill(tuple(self.RGB))
            self.backrect = (0, 0)
        pygame.display.flip()

        """Get the handle of the save data file"""
##        try:
##            self.save_file = Savefile('save.sav', 'a')
##        except:
##            print "Fail to open the file in top list"
        
        self.flag_loop = True
        self.flag_enter = False
##        self.date = self.getDate()
        self.key = KeyInput()
        self.index = 10
        self.input = []
        self.inputposilist = []
        self.spacing = [30, 100, 300, 400]
        self.alpha = ['a', 'b', 'c', 'd', 'e', 'f', 'g',
                      'h', 'i', 'j', 'k', 'l', 'm', 'n',
                      'o', 'p', 'q', 'r', 's', 't', 'u',
                      'v', 'w', 'x', 'y', 'z']
        self.upalpha = [all.upper() for all in self.alpha]
        self.numbers = [str(i) for i in range(0, 10)]
        self.legalkeys = self.alpha + self.upalpha + self.numbers
        name = 'save.sav'
        self.fullname = os.path.join('data', name)
        
        

    def MainLoop(self):
        """It is the Main Loop of the Top List"""
        
        self.screen.blit(self.background, (0, 0))

        self.title = 'TOP 10'
        titletext, titletextposi = load_text(
            self.title, x = self.width/2, y = 50, size = 48)
        self.screen.blit(titletext, titletextposi)

        self.displaysave()

        pygame.display.flip()

        while self.flag_loop:
#----------------------------------------------------------------------------------------        
#accept the input from keyboard
#----------------------------------------------------------------------------------------
            for event in pygame.event.get():
                event_type = event.type
                try:
                    event_key = event.key
                except:
                    event_key = 0
                    pass
                self.temp = self.key.key_class(event_type, event_key)

#----------------------------------------------------------------------------------------        
#deal with the input information
#----------------------------------------------------------------------------------------                        
                if self.temp == 'quit':
                    self.flag_loop = False
                elif self.temp == 'backspace':
                    try:
                        self.input.pop()
                    except:
                        print "Nothing can be backspace..."
                elif self.temp == 'enter':
                    try:
                        self.player[self.index] = ''.join(self.input)
                    except:
                        pass
                    self.content = self.updatesave()
                    self.f = open(self.fullname, 'w')
                    self.f.write(self.content)
                    self.f.close()
                    
                    self.flag_enter = True
                    pass
                elif (self.temp in self.legalkeys) and (not self.flag_enter):
                    if len(self.input) <= 12:
                        self.input.append(self.temp)
                    else:
                        print "Your name is too long..."
                        pass
                    
                elif self.temp != 'error':
                    print "The key you pressed is not defined, Try another..."
                else:
                    break
#----------------------------------------------------------------------------------------        
#redraw the screen with the new input
#----------------------------------------------------------------------------------------                        
                self.inputtext, self.inputtextposi = load_text(
                    ''.join(self.input) + (self.flag_enter and ' ' or '_'),
                    l = self.spacing[1], y = 100 + (self.index + 1) * 35)
                self.inputposilist.append(self.inputtextposi)
                self.screen.blit(self.background, self.backrect)
                self.screen.blit(titletext, titletextposi)                
                #self.displaysave()
                self.screen.blit(self.inputtext, self.inputtextposi)
##                print type(self.inputtextposi)
##                print self.inputtextposi
                pygame.display.update(self.inputposilist)

                
    def readsave(self):
        try:
            f = open(self.fullname, 'r')
            content = f.read()
            f.close()
        except:
            content = 'Error\nError\tError'
            print 'Error, save.sav file not found!!!'

        tempcontent = content.split('\n')
        tempcontent = self.removenone(tempcontent)
        tempcontent = [all.split('\t') for all in tempcontent]
        tempcontent = [self.removenone(all) for all in tempcontent]

        self.serialno = []
        self.player = []
        self.gradeslist = []
        self.datelist = []
        toplist = [self.serialno, self.player,
                        self.gradeslist, self.datelist]
        for i in range(len(tempcontent)):
            toplist[0].append(tempcontent[i][0])
            toplist[1].append(tempcontent[i][1])
            toplist[2].append(tempcontent[i][2])
            toplist[3].append(tempcontent[i][3])

        return toplist

    def insertsave(self, grade = 0):
        self.grade = grade
        self.toplist = self.readsave()
        index = len(self.gradeslist)
        for grades in self.gradeslist:
            if self.grade >= int(grades):
                index = self.gradeslist.index(grades)
                break
            else:
                pass
        self.player.insert(index, '_')
        self.gradeslist.insert(index, str(self.grade))
        self.datelist.insert(index, time.ctime())
        self.poplast()
        self.index = index

    def poplast(self):
        self.player.pop()
        self.gradeslist.pop()
        self.datelist.pop()
        
    def updatesave(self):
        updatecontent = ''
        print self.serialno
        for i in range(len(self.serialno)):
            temp = self.serialno[i] + '\t\t' + self.player[i] \
                   + '\t\t\t' + self.gradeslist[i] + '\t\t' + \
                   self.datelist[i]
            updatecontent = updatecontent + temp + '\n'
        return updatecontent

    def displaysave(self):
        toplistcopy = []
        for i in self.toplist:
            temp = [all for all in i]
            toplistcopy.append(temp)
        toplistcopy[0].insert(0, 'No.')
        toplistcopy[1].insert(0, 'Name')
        toplistcopy[2].insert(0, 'Grade')
        toplistcopy[3].insert(0, '               Date')
        text = []
        textposi = []
        for i in range(len(toplistcopy[0])):
            tempt = []
            temptp = []
            for j in range(len(toplistcopy)):
                temptext, temptextposi = load_text(
                    toplistcopy[j][i], l = self.spacing[j],
                    y = 100 + i * 35)
                tempt.append(temptext)
                temptp.append(temptextposi)            
            text.append(tempt)
            textposi.append(temptp)

        
        for i in range(len(text)):
            for j in range(len(text[i])):
                self.screen.blit(text[i][j], textposi[i][j])
        print self.toplist
        print toplistcopy

        
    
    def removenone(self, rawlist):
        return [all for all in rawlist if all != '']


if __name__ == '__main__':
    toplist = TopList()
    toplist.insertsave(1350)
    toplist.MainLoop()
##    toplist.Quit()
    pygame.display.quit()
    pygame.quit()
    try:
        sys.exit()
    except SystemExit:
        print "The Game is Quit Now..."  
    pass
