#-------------------------------------------------
#The file is for the Calc24P as image, sound
#or text load.
#It is written by Chao Xiong, July, 2006
#The version is 1.05
#-------------------------------------------------



import os
import pygame
import random
from pygame.locals import *


#--------------------------------------------------------
# The following two functions are gotten from 
# http://www.pygame.org, the example of chimp
#--------------------------------------------------------
def load_image(name, colorkey=None):
    fullname = os.path.join('data', name)
    try:
        image = pygame.image.load(fullname)
    except pygame.error, message:
        print 'Cannot load image:', fullname
        raise SystemExit, message
    image = image.convert()
    if colorkey is not None:
        if colorkey is -1:
            colorkey = image.get_at((0,0))
        image.set_colorkey(colorkey, RLEACCEL)
    return image, image.get_rect()



def load_sound(name):
    class NoneSound:
        def play(self): pass
    if not pygame.mixer or not pygame.mixer.get_init():
        return NoneSound()
    fullname = os.path.join('data', name)
    try:
        sound = pygame.mixer.Sound(fullname)
    except pygame.error, message:
        print 'Cannot load sound:', fullname
        raise SystemExit, message
    return sound
        


#--------------------------------------------------------
# The following function is a modified edition for 
# the text loading according to above functions
#--------------------------------------------------------
def load_text(rawtext, fontname = None, l = 0, r = 0, x = 0, y = 0, size = 24):
    rf = random.randint
    color = (rf(0, 255), rf(0, 255), rf(0, 255))
    if not fontname:
        fontname = 'freesansbold.ttf'
    fullname = os.path.join('data', fontname)
    textposi = []
    text = []
    pygame.init()
    countn = rawtext.count('\n')
    newtext = rawtext.split('\n')
    try:
        font = pygame.font.Font(fullname, size)
        if countn > 0:
            for i in range(countn + 1):            
                text.append(font.render(newtext[i], 1, color))
                if x > 0:
                    textposi.append(text[i].get_rect(
                        center = (x, y + i * size * 1.5)))
                elif l > 0: 
                    textposi.append(text[i].get_rect(
                        left = l, centery = y + i * size * 1.5))
                elif r > 0:
                    textposi.append(text[i].get_rect(
                        right = r, centery = y + i * size * 1.5))
        elif countn == 0:
            text = font.render(rawtext, 1, color)
            if x > 0:
                textposi = text.get_rect(center = (x, y))
            elif l > 0:
                textposi = text.get_rect(left = l, centery = y)
            elif r > 0:
                textposi = text.get_rect(right = r, centery = y)
    except:
        print "Warning, font is not available..."  

    return text, textposi
