#-------------------------------------------------
#The file is for the Calc24P as a start menu.
#It is written by Chao Xiong, July, 2006
#The version is 1.05
#-------------------------------------------------



"""It is the Menu for the 24 point game.
require the player inputs the number of questions.
Loop the game after the toplist is finished."""



import os, sys
import pygame
import calc24p
import toplist
from keyInput import KeyInput
from pygame.locals import *
from textimage import *


if not pygame.font: print "Warning, fonts disabled"
if not pygame.mixer: print "Warning, sounds disabled"


class MainMenu:
    """The main class for the menu of the game."""

    def __init__(self, width = 640, height = 480):
        """Initializing the class and pygame"""
        pygame.init()
        """set the window size"""
        self.width = width
        self.height = height
        """create the screen"""
        pygame.display.set_caption('24 Points Calculation')
        self.screen = pygame.display.set_mode((self.width, self.height))
        self.flag_loop = True
        self.flag_enter = False
        self.RGB = [self.R, self.G, self.B] = [0, 0, 0]
        self.key = KeyInput()
        self.numbers = [str(i) for i in range(0, 10)]
        self.legalkeys = self.numbers
        self.input = []

    def MainLoop(self):
        """It is the main loop of the menu"""

        """Create the background"""
        
        try:
            self.background, self.backrect = load_image('question.jpg')
            self.screen.blit(self.background, self.backrect)
        except:
            self.background = pygame.Surface(self.screen.get_size())
            self.background = self.background.convert()
            self.background.fill(tuple(self.RGB))
            self.backrect = (0, 0)

        
        self.questions = 'How many questions   \ndo you want to play:   \n\
        (1 to 6561 is expected)'
        
##        ques, quesposi = load_text(self.questions, x = self.width/2,
##                                   y = 100)
        ques, quesposi = load_text(self.questions, fontname = 'BRADHITC.TTF',
                                   r = self.width, y = 150, size = 32)
        for i in range(len(ques)):
            self.screen.blit(ques[i], quesposi[i])
        

        pygame.display.flip()


        while self.flag_loop:
#----------------------------------------------------------------------------------------        
#accept the input from keyboard
#----------------------------------------------------------------------------------------           
            for event in pygame.event.get():
                event_type = event.type
                try:
                    event_key = event.key
                except:
                    event_key = 0
                self.temp = self.key.key_class(event_type, event_key)
#----------------------------------------------------------------------------------------        
#deal with the input information
#----------------------------------------------------------------------------------------                        
                if self.temp == 'quit':
                    self.flag_loop = False
                elif self.temp == 'backspace':
                    try:
                        self.input.pop()
                    except:
                        print "Nothing can be backspace..."
                elif self.temp == 'enter':
                    self.flag_enter = True
                    self.flag_loop = False

                elif self.temp in self.legalkeys:
                    self.input.append(self.temp)
                elif self.temp != 'error':
                    print "The key you pressed is not defined, Try another..."
                else:
                    break
#----------------------------------------------------------------------------------------        
#redraw the screen with the new input
#----------------------------------------------------------------------------------------                        
                self.inputtext, self.inputtextposi = load_text(
                    ''.join(self.input),
                    x = self.width - 150, y = self.height/2 + 60, size = 36)
                self.screen.blit(self.background, (0, 0))
                for i in range(len(ques)):
                    self.screen.blit(ques[i], quesposi[i])
                self.screen.blit(self.inputtext, self.inputtextposi)
                pygame.display.flip()


    def getAmount(self):
        if self.flag_enter:
            return eval(''.join(self.input))
        


if __name__ == '__main__':
    while 1:
        mainMenu = MainMenu(720, 480)
        mainMenu.MainLoop()
        questionamount = mainMenu.getAmount()
        print "question amount = ", questionamount

        if questionamount >= 1 and questionamount <= 6561:
            grade = 0
            while calc24p.Calc24p.count <= questionamount - 1:
                MainWindow = calc24p.Calc24p(720, 480)
                MainWindow.MainLoop()
                grade = grade + MainWindow.Grades() + 50

            grade = grade / questionamount

            MainTop = toplist.TopList(720, 480)
            MainTop.insertsave(grade)
            MainTop.MainLoop()
            calc24p.Calc24p.count = 0
            questionamount = 0
        else:
            

            break

        
    pygame.display.quit()
    pygame.quit()
    try:
        sys.exit()
    except SystemExit:
        print "The Game is Quit Now..."  
        

                    
    
