#-------------------------------------------------
#The file is for the Calc24P as keyboard input.
#It is written by Chao Xiong, July, 2006
#The version is 1.05
#-------------------------------------------------



import pygame
from pygame.locals import *

class KeyInput:
    """Accept the input from Keyboard, Mouse or Joystick."""

    def __init__(self):
        """define the dictionary for keyboard."""
        self.numbers = {48 : '0', 49 : '1', 50 : '2', 51 : '3',
                        52 : '4', 53 : '5', 54 : '6', 55 : '7',
                        56 : '8', 57 : '9'}
        self.alphabet = { 97 : 'a',  98 : 'b',  99 : 'c', 100 : 'd',
                         101 : 'e', 102 : 'f', 103 : 'g', 104 : 'h',
                         105 : 'i', 106 : 'j', 107 : 'k', 108 : 'l',
                         109 : 'm', 110 : 'n', 111 : 'o', 112 : 'p',
                         113 : 'q', 114 : 'r', 115 : 's', 116 : 't',
                         117 : 'u', 118 : 'v', 119 : 'w', 120 : 'x',
                         121 : 'y', 122 : 'z'}
        self.controlchar = {8 : 'backspace', 13 : 'enter', 27 : 'esc'}
        self.shiftchar = {48 : ')', 49 : '!', 50 : '@', 51 : '#',
                          52 : '$', 53 : '%', 54 : '^', 55 : '&',
                          56 : '*', 57 : '(', 61 : '+', 45 : '_'}
        self.shiftalpha = { 97 : 'A',  98 : 'B',  99 : 'C', 100 : 'D',
                           101 : 'E', 102 : 'F', 103 : 'G', 104 : 'H',
                           105 : 'I', 106 : 'J', 107 : 'K', 108 : 'L',
                           109 : 'M', 110 : 'N', 111 : 'O', 112 : 'P',
                           113 : 'Q', 114 : 'R', 115 : 'S', 116 : 'T',
                           117 : 'U', 118 : 'V', 119 : 'W', 120 : 'X',
                           121 : 'Y', 122 : 'Z'}
        self.operators = {43 : '+', 45 : '-', 42 : '*', 47 : '/', 32 : ' '}
        self.lowcase = {}
        self.upcase = {}
        self.lowcase.update(self.numbers)
        self.lowcase.update(self.alphabet)
        self.lowcase.update(self.operators)
        self.lowcase.update(self.controlchar)
        self.upcase.update(self.shiftchar)
        self.upcase.update(self.shiftalpha)
        self.shift_mod = False
        self.returnchar = ''        

    def key_class(self, event_type, event_key):
        self.returnchar = 'error'
        if event_type == pygame.QUIT:
            self.returnchar = self.key_quit()
            
        elif event_type == KEYDOWN:
            if event_key == 303 or event_key == 304:
                self.shift_mod = True
            if not self.shift_mod:
                self.returnchar = self.key_down(event_key)
            else:
                self.returnchar = self.key_shift_down(event_key)

        elif event_type == KEYUP:
            if event_key == 303 or event_key == 304:
                self.shift_mod = False
                
        return self.returnchar    

        pass

    def key_down(self, key):
        try:
            self.char_key = self.lowcase[key]
            return self.char_key
        except:
            if key != 303 and key != 304:
                print "Your input is not found...Please Try another key..."
            return 'error'
        pass

    def key_shift_down(self, key):
        try:
            self.char_key = self.upcase[key]
            return self.char_key
        except:
            if key != 303 and key != 304:
                print "Your input is not found...Please Try another key..."
            return 'error'
        pass

    def key_up(self, key):
        pass

    def key_shift_up(self, key):
        pass

    def key_quit(self):
        return 'quit'
        pass
