#-------------------------------------------------
#The file is for the Calc24P as a calculation.
#It is written by Chao Xiong, July, 2006
#The version is 1.05
#-------------------------------------------------



"""It is the main program for 24 point game.
The main GUI and loop is built here.
A class named Calc24p is defined for the main class.
"""

from __future__ import division
import os, sys
import pygame
import random
import problem
import toplist
import time
from keyInput import KeyInput
from pygame.locals import *
from randnum import *
from textimage import *


if not pygame.font: print "Warning, fonts disabled"
if not pygame.mixer: print "Warning, sounds disabled"

"""Creat the list of constant varibles"""
numberList = range(0,10)
operatorList = ['(', ')', '+', '-', '*', '/']


class Calc24p:
    """The main class for the game. It calls the scripts and
    makes GUI available. It realizes the mainloop for running
    the game."""
    count = 0

    def __init__(self, width = 640, height = 480):
        """Initializing the class and pygame"""
        self.__class__.count += 1
        pygame.init()
        """Set the window size"""
        self.width = width
        self.height = height
        """Creat the screen"""
        pygame.display.set_caption('24 Points Calculation')
        self.screen = pygame.display.set_mode((self.width, self.height))
        """Set the flag for the loop"""
        self.flag_loop = True
        self.flag_right = False
        self.problemNo = 'Question ' + str(self.__class__.count)
        self.RGB = [self.R, self.G, self.B] = [0, 0, 0]
        self.key = KeyInput()
        self.numbers = [str(i) for i in range(0, 10)]
        self.chars = ['+', '-', '*', '/', '(', ')']
        self.legalkeys = self.numbers + self.chars
        self.time = time.time()


    def MainLoop(self):
        """It is the Main Loop of the game"""
        
        """Creat the background"""
        try:
            self.background, self.backrect = load_image('noidea.jpg')
            self.screen.blit(self.background, self.backrect)
        except:
            self.background = pygame.Surface(self.screen.get_size())
            self.background = self.background.convert()
            self.background.fill(tuple(self.RGB))
            self.backrect = (0, 0)    


##        self.image, self.rect = load_image('background.bmp', -1)
##        self.screen.blit(self.image, self.rect)

        pygame.display.flip()

#----------------------------------------------------------------------------------------        
#generate the problem of 24P game.
#----------------------------------------------------------------------------------------
        self.problem, self.equation = problem.Randproblem().getProblem()
        print self.problem

#----------------------------------------------------------------------------------------        
#draw the problem
#----------------------------------------------------------------------------------------
        text, textposi = load_text(self.problem, fontname = 'curlz.ttf',
                                   x = self.width/2, y = 80, size = 48)
        self.screen.blit(text, textposi)
        reclist = [textposi]
#----------------------------------------------------------------------------------------        
#display the No. of problem
#----------------------------------------------------------------------------------------
        self.protext, self.protextposi = load_text(self.problemNo,
                                                   r = self.width - 36, y = 36)
        self.screen.blit(self.protext, self.protextposi)
        reclist.append(self.protextposi)
        pygame.display.update(reclist)


        self.input = []
        self.shift_mod = 0
        self.count = 0
        self.flag_enter = False
        self.inputtext = ''
        self.inputtextposi = ''

        while self.flag_loop:
            self.count -= 1
#----------------------------------------------------------------------------------------        
#accept the input from keyboard
#----------------------------------------------------------------------------------------
            for event in pygame.event.get():
                #print event.type
                event_type = event.type
                try:
                    event_key = event.key
                except:
                    event_key = 0
                    pass
                self.temp = self.key.key_class(event_type, event_key)

#----------------------------------------------------------------------------------------        
#deal with the input information
#----------------------------------------------------------------------------------------                        
                if self.temp == 'quit':
                    self.__class__.count = 10000
                    self.flag_loop = False
                elif self.temp == 'backspace':
                    try:
                        self.input.pop()
                    except:
                        print "Nothing can be backspace..."
                elif self.temp == 'enter':
                    self.flag_enter = True
                    try:
                        self.result = eval(''.join(self.input))
                    except:
                        self.result = -9999
                    self.flag_check = checkInt(self.problem, self.input)
                    self.input = conclude(self.result, self.flag_check)
                    try:
                        if self.input[0][0] == 'C':
                            self.background, self.backrect = load_image('win.jpg')
                        elif self.input[0][0] == 'S':
                            self.background, self.backrect = load_image('wrong.jpg')
                        elif self.input[0][0] == 'A':
                            self.background, self.backrect = load_image('miss.jpg')
                    except:
                        self.background = pygame.Surface(self.screen.get_size())
                        self.background = self.background.convert()
                        self.background.fill(tuple(self.RGB))
                        self.backrect = (0, 0) 

                elif self.temp == 'esc':
                    self.input = ''
                    try:
                        self.background, self.backrect = load_image('esc.jpg')
                    except:
                        self.background = pygame.Surface(self.screen.get_size())
                        self.background = self.background.convert()
                        self.background.fill(tuple(self.RGB))
                        self.backrect = (0, 0) 
                elif self.temp in self.legalkeys:
                    self.input.append(self.temp)
                elif self.temp != 'error':
                    print "The key you pressed is not defined, Try another..."
                else:
                    break
                
#----------------------------------------------------------------------------------------        
#redraw the screen with the new input
#----------------------------------------------------------------------------------------                        
                self.inputtext, self.inputtextposi = load_text(
                    ''.join(self.input), fontname = 'BRADHITC.TTF',
                    x = self.width/2, y = self.height/2, size = 48)
                self.screen.blit(self.background, self.backrect)
##                self.screen.blit(self.image, self.rect)
                self.screen.blit(text, textposi)        
                self.screen.blit(self.inputtext, self.inputtextposi)
                self.screen.blit(self.protext, self.protextposi)
                pygame.display.flip()
                try:
                    if self.temp == 'esc':
                        time.sleep(1)
                        self.flag_loop = False
                        self.input[0][0] == ''
                    if self.input[0][0] == 'C':
                        time.sleep(2)    
                        self.flag_right = True
                        self.flag_loop = False
                        self.input[0][0] == ''
##                    elif self.input[0][0] == 'S':
##                        time.sleep(0.5)
##                    elif self.input[0][0] == 'A':
##                        time.sleep(0.5)
                    
                    
                        
                except:
                    pass
#----------------------------------------------------------------------------------------        
#get the clue on the bottom of screen
#----------------------------------------------------------------------------------------                        
            if self.count <= 0:
                self.count = 500000
                self.clues = clue()

                if self.flag_enter:
                    self.clues = clue(self.equation)
#----------------------------------------------------------------------------------------        
#redraw the screen with the new clues
#----------------------------------------------------------------------------------------                                            
                self.cluetext, self.cluetextposi = load_text(
                    self.clues, x = self.width/2, y = self.height-36)                
                self.screen.blit(self.background, self.backrect)
##                self.screen.blit(self.image, self.rect)
                self.screen.blit(text, textposi)
                try:
                    self.screen.blit(self.inputtext, self.inputtextposi)
                    reclist.append(self.inputtextposi)
                except:
                    pass
                self.screen.blit(self.protext, self.protextposi)
                self.screen.blit(self.cluetext, self.cluetextposi)                    
                pygame.display.flip()     

        return
    def Grades(self):
        self.time = time.time() - self.time
        self.grade = self.flag_right \
                     and (600 + (62 - int(self.time)) * 10) \
                     or (-10) * int(self.time)
        return self.grade
        pass
    

if __name__ == "__main__":
    while 1:
        problemamount = raw_input('How many problems do you want to play: ')
        try:
            problemamount = int(problemamount)
            if problemamount >= 1 and problemamount <= 6561:
                break
            else:
                print 'Illegal or Too many...'
        except:
            print 'Please Input an integer...'    
    
    grade = 0
    while Calc24p.count <= problemamount-1:
        MainWindow = Calc24p(720, 480)    
        MainWindow.MainLoop()
        grade = grade + MainWindow.Grades() + 20

    grade = grade/(problemamount)

    MainTop = toplist.TopList(720, 480)
    MainTop.insertsave(grade)
    MainTop.MainLoop()
    
    pygame.display.quit()
    pygame.quit()
    try:
        sys.exit()
    except SystemExit:
        print "The Game is Quit Now..."  
        

                    
                    
                    
        

        
