import os
import sys
import urllib2

import time

class DownLoader(object):
    def __init__(self, url, filename):
        self.url = url
        self.filename = filename
        self.length = 0
    def _size(self, headers):
        content_range = headers.get('content-range')
        if not content_range or '/' not in content_range:
            return 0
        return int(content_range.split('/')[-1])
    def set_timeout(self, timeout):
        import socket
        socket.setdefaulttimeout(timeout)
    def down(self):
        def filesize():
            if os.path.exists(self.filename):
                return os.path.getsize(self.filename)
            return 0
        def down():
            request = urllib2.Request(self.url)
            request.add_header("Range", "bytes=%d-"%(filesize(),))
            print 'go', self.length, filesize(), time.time()
            try:
                file = open(self.filename, 'ab')
                try:
                    opener = urllib2.build_opener()
                    netfile = opener.open(request)
                    print netfile.headers.dict
                    if self.length == 0:
                        self.length = self._size(netfile.headers.dict)
                    data = netfile.read(1024)
                    while data:
                        print self.length, filesize(), time.time()
                        file.write(data)
                        file.flush()
                        data = netfile.read(1024)
                    netfile.close()
                finally:
                    file.close()
            except socket.timeout:
                pass
            except IOError:
                import traceback
                traceback.print_exc()
            return filesize() != self.length and self.length != 0
        while down():
            pass

if __name__ == "__main__":
    url = 'http://jaist.dl.sourceforge.net/sourceforge/karrigell/Karrigell-2.3.3.tar.bz2'
    filename = 'Karrigell-2.3.3.tar.bz2'
    DownLoader = DownLoader(url, filename)
    DownLoader.down()
