import os
import sys
import pycurl

class DownLoader(object):
    def __init__(self, url, filename):
        self.url = url
        self.filename = filename
        self.length = self._size()
        self.set_timeout(15)
    def _size(self):
        curl = pycurl.Curl()
        curl.setopt(pycurl.URL, self.url)
        curl.setopt(pycurl.FOLLOWLOCATION, 1)
        curl.setopt(pycurl.MAXREDIRS, 5)
        curl.setopt(pycurl.NOBODY, 1)
        curl.perform()
        return int(curl.getinfo(pycurl.CONTENT_LENGTH_DOWNLOAD))
    def set_timeout(self, timeout):
        self.timeout = timeout
    def down(self):
        def filesize():
            if os.path.exists(self.filename):
                return os.path.getsize(self.filename)
            return 0
        def down():
            if self.length:
                print filesize()*100/self.length
            range = "%d-"%(filesize(),)
            try:
                file = open(self.filename, 'ab')
                try:
                    curl = pycurl.Curl()
                    curl.setopt(pycurl.URL, self.url)
                    curl.setopt(pycurl.FOLLOWLOCATION, 1)
                    curl.setopt(pycurl.MAXREDIRS, 5)
                    curl.setopt(pycurl.RANGE, range)
                    curl.setopt(pycurl.WRITEFUNCTION, file.write)
                    curl.setopt(pycurl.TIMEOUT, self.timeout)
                    curl.perform()
                finally:
                    file.close()
            except pycurl.error:
                import traceback
                traceback.print_exc()
            return filesize() != self.length and self.length != 0
        while down():
            pass

if __name__ == "__main__":
    url = sys.argv[1]
    filename = sys.argv[2]
    DownLoader = DownLoader(url, filename)
    DownLoader.down()
