#!/usr/bin/env python
#coding=utf8 

import re
import os
import shutil
import sys
import getopt

class Application(object):
    def __init__(self):
        self.modules = ['config', 'mpl', 'preprocessor']
        self.head_finder = re.compile(r"^\s*#\s*include\s*[\"<](.+?)[\">]", re.M)
        self.file_matcher = re.compile(r".*\.[hc]p*$", re.I)
    def set_boost_path(self, path):
        self.boost_path = path
    def set_dest_path(self, path):
        self.dest_path = path
        if not os.path.exists(path):
            os.mkdir(path)
    def add_module(self, module):
        self.modules.append(module)
    def module_path(self, module):
        return os.path.join(self.boost_path, 'boost', module+'.hpp')
    def parse_file(self, filename, container):
        if not os.path.isfile(filename):
            return
        filename = os.path.normcase(filename.lower())
        if filename in container:
            return
        container.add(filename)
 
        root = os.path.dirname(filename)
        for head in self.head_finder.findall(open(filename).read()):
            #在文件所在的目录查找头文件
            _ = os.path.join(root, head)
            self.parse_file(_, container)
            #在boost目录下查找该头文件
            _ = os.path.join(self.boost_path, head)
            self.parse_file(_, container)
 
    def parse_dir(self, dir, container):
        if not os.path.exists(dir):
            return
        for root, dirs, files in os.walk(dir):
            for file in files:
                if self.file_matcher.match(file):
                    self.parse_file(os.path.join(root, file), container)
                else:
                    print os.path.join(root, file)
 
    def parse_module(self, module, container):
        head_file = os.path.join(self.boost_path, 'boost' ,module+'.hpp')
        head_dir = os.path.join(self.boost_path, 'boost', module)
        src_dir = os.path.join(self.boost_path, 'libs', module, 'src')
        self.parse_file(head_file, container)
        self.parse_dir(head_dir, container)
        self.parse_dir(src_dir, container)
 
    def run(self):
        container = set()
        for module in self.modules:
            self.parse_module(module, container)
        for src in container:
            dst = self.dest_path+src[len(self.boost_path):]
            dirname = os.path.dirname(dst)
            if not os.path.exists(dirname):
                os.makedirs(dirname)
            shutil.copyfile(src, dst)
def main():
    app = Application()
    opts, args = getopt.getopt(sys.argv[1:], 'bd:', ['boost=','dest='])
    for o, a in opts:
        if o == '--boost' or o == '-b':
            app.set_boost_path(a)
        elif o == '--dest' or o == '-d':
            app.set_dest_path(a)
    for a in args:
        app.add_module(a)
    app.run()

if __name__ == '__main__':
    main()
